<?php defined('SYSPATH') or die('No direct script access.');

class Task_Problem_Report extends Minion_Task
{

    protected function _execute(array $params)
    {
        Task_Helper::createWorker('Problem:Report', $this);
    }

    public function Worker(GearmanJob $job)
    {
        $problems = json_decode($job->workload());

        foreach($problems as $problem) {
            Database::instance()->begin();
            try {
                $modelProblem = ORM::factory('Problem', [
                    'server' => $problem->server,
                    'filename' => $problem->filename,
                    'logline' => $problem->logline,
                ]);
                $modelProblem->server = $problem->server;
                $modelProblem->filename = $problem->filename;
                $modelProblem->logline = $problem->logline;
                $modelProblem->level = $problem->level;
                $modelProblem->description = $problem->description;
                if (isset($problem->timestamp)) {
                    $modelProblem->created_at = date('Y-m-d H:i:s', $problem->timestamp);
                } else {
                    $modelProblem->created_at = date('Y-m-d H:i:s');
                }
                $modelProblem->save();
            } catch(Exception $e) {
                Kohana::$log->add(Log::ERROR, Kohana_Exception::text($e), null, ['exception' => $e]);
                Database::instance()->rollback();
                continue;
            }
            
            Database::instance()->commit();
        }
    }
}